﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.IO

Public Class DirectoryScanner

    Const MB As Long = 1024 * 1024

    ''' <summary>
    ''' 处理 DirectoryScanner 的 Load 事件。
    ''' </summary>
    Private Sub DirectoryScanner_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' 创建初始 ListView 列
        ListView1.Columns.Add("Size", 90, HorizontalAlignment.Left)
        ListView1.Columns.Add("Folder Name", 400, HorizontalAlignment.Left)
    End Sub

    ''' <summary>
    ''' 此子例程将用户在 TreeView 上选择的 strSubDirectory 添加到
    ''' ListView，然后设置文本、大小和颜色。
    ''' </summary>
    Private Sub AddToListView(ByVal strSize As String, ByVal strFolderName As String)
        Dim listViewItem As New ListViewItem()
        Dim listViewSubItem As ListViewItem.ListViewSubItem

        listViewItem.Text = strSize
        listViewItem.ForeColor = GetSizeColor(strSize)

        listViewSubItem = New ListViewItem.ListViewSubItem()
        listViewSubItem.Text = strFolderName

        listViewItem.SubItems.Add(listViewSubItem)
        ListView1.Items.Add(listViewItem)
    End Sub

    ''' <summary>
    ''' 此子例程根据目录及其所有子目录的总大小
    ''' 返回 Color。这是两个重载中的一个重载。
    ''' </summary>
    Private Function GetSizeColor(ByVal strSize As String) As System.Drawing.Color
        Return GetSizeColor(CLng(CDbl(strSize.Substring(0, _
            strSize.LastIndexOf("M") - 1)) * MB))
    End Function

    ''' <summary>
    ''' 此函数根据目录及其所有子目录的总大小
    ''' 返回 Color。这是两个重载中的另一个重载。
    ''' </summary>
    Private Function GetSizeColor(ByVal intSize As Long) As System.Drawing.Color
        Select Case intSize
            Case 200 * MB To 500 * MB
                Return System.Drawing.Color.Gold
            Case Is > 500 * MB
                Return System.Drawing.Color.Red
            Case Else
                Return System.Drawing.Color.Green
        End Select
    End Function

    ''' <summary>
    ''' 此函数返回目录及其所有子目录的大小。
    ''' </summary>
    Public Function GetDirectorySize(ByVal strDirPath As String, _
        ByVal dnDriveOrDirectory As DirectoryNode) As Long

        Try
            Dim astrSubDirectories As String() = Directory.GetDirectories(strDirPath)
            Dim strSubDirectory As String

            ' 当前目录的大小取决于
            ' 数组 astrSubDirectories 中的子目录的大小。因此循环访问
            ' 该数组并使用递归计算出当前目录
            ' 及其所有子目录的总大小。
            For Each strSubDirectory In astrSubDirectories
                Dim dnSubDirectoryNode As DirectoryNode
                dnSubDirectoryNode = New DirectoryNode()

                ' 将节点文本设置为完整路径的最后一部分。
                dnSubDirectoryNode.Text = _
                    strSubDirectory.Remove(0, strSubDirectory.LastIndexOf("\") + 1)

                ' 注意下面一行使用了递归。
                dnDriveOrDirectory.Size += _
                    GetDirectorySize(strSubDirectory, dnSubDirectoryNode)
                dnDriveOrDirectory.Nodes.Add(dnSubDirectoryNode)
            Next

            ' 在 size 的计算中加上当前目录中
            ' 所有文件的大小。
            Dim astrFiles As String() = Directory.GetFiles(strDirPath)
            Dim strFileName As String
            Dim Size As Long = 0

            For Each strFileName In astrFiles
                dnDriveOrDirectory.Size += New FileInfo(strFileName).Length
            Next

            ' 根据计算所得的总大小设置 TreeNode 的颜色。
            dnDriveOrDirectory.ForeColor = _
                GetSizeColor(dnDriveOrDirectory.Size)

        Catch exc As Exception
            ' 不做任何操作。只是跳过不能读取的所有目录。控制
            ' 将传递到 End Try 后的第一行。
        End Try

        ' 返回此目录的总大小。
        Return dnDriveOrDirectory.Size

    End Function

    ''' <summary>
    ''' 当展开某一目录节点时，将其子目录添加到 ListView 中。
    ''' </summary>
    Public Sub ShowSubDirectories(ByVal dnDrive As DirectoryNode)
        Dim strSubDirectory As DirectoryNode

        ListView1.Items.Clear()

        For Each strSubDirectory In dnDrive.Nodes
            AddToListView(Format(strSubDirectory.Size / MB, "F") + "MB", _
                strSubDirectory.Text)
        Next
    End Sub

    ''' <summary>
    ''' 关闭应用程序
    ''' </summary>
    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub

    Private Sub AllDirectoriesToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AllDirectoriesToolStripMenuItem.Click
        Me.Cursor = Cursors.WaitCursor

        ' 获取包含所有逻辑驱动器的数组。
        Dim drives As String() = Directory.GetLogicalDrives()
        Dim drive As String

        TreeView1.Nodes.Clear()
        ListView1.Items.Clear()

        For Each drive In drives
            Dim dnDrive As DirectoryNode

            Try
                ' 创建表示每个逻辑驱动器的 DirectoryNode
                ' 并将其添加到 TreeView。
                dnDrive = New DirectoryNode()
                dnDrive.Text = drive.Remove(Len(drive) - 1, 1)
                TreeView1.Nodes.Add(dnDrive)

                ' 通过累加该驱动器中的所有子目录的大小，
                ' 计算该驱动器的大小。
                dnDrive.Size += GetDirectorySize(drive, dnDrive)
            Catch exc As Exception
                ' 不做任何操作。只是跳过不能读取的所有目录。控制
                ' 将传递到 End Try 后的第一行。
            End Try
        Next
        Me.Cursor = Cursors.Arrow
    End Sub

    Private Sub FromOneDirectoryToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FromOneDirectoryToolStripMenuItem.Click
        Me.Cursor = Cursors.WaitCursor
        ' 显示“FolderBrowser”对话框，并将初始目录设置为
        ' 用户选择的目录。
        Dim SelectedDirectory As String = FolderBrowser.ShowDialog()
        Dim SelectedDirectoryNode As DirectoryNode

        TreeView1.Nodes.Clear()
        ListView1.Items.Clear()

        Try
            ' 将表示所选目录的 DirectoryNode 添加到
            ' TreeView 中。
            SelectedDirectoryNode = New DirectoryNode()
            SelectedDirectoryNode.Text = SelectedDirectory
            TreeView1.Nodes.Add(SelectedDirectoryNode)

            ' 通过累加所选目录的所有子目录的大小，
            ' 计算该所选目录的大小。
            SelectedDirectoryNode.Size += GetDirectorySize(SelectedDirectory, _
                SelectedDirectoryNode)

        Catch exc As Exception
            ' 不做任何操作。只是跳过不能读取的所有目录。控制
            ' 将传递到 End Try 后的第一行。
        End Try
        Me.Cursor = Cursors.Arrow
    End Sub

    ''' <summary>
    ''' 处理 TreeView 的 AfterExpand 事件，该事件不是在选择
    ''' TreeView 后发生的，而是在应用程序确定应允许用户尝试展开
    ''' 节点后发生。如果需要，应用程序使用相应的 BeforeExpand
    ''' 事件处理程序做出这一决定。所有 Before______ 事件
    ''' 都传递包含 Cancel 属性的 TreeViewCancelEventArgs 对象。
    ''' 可以使用该属性禁止用户的操作。因此，可将“AfterExpand”
    ''' 事件相应命名为“AfterExpandApproval”。
    ''' </summary>
    Private Sub TreeView1_AfterExpand(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles TreeView1.AfterExpand
        e.Node.Expand()
        ShowSubDirectories(CType(e.Node, DirectoryNode))
    End Sub

    ''' <summary>
    ''' 处理 TreeView 的 AfterSelect 事件，该事件不是在选择
    ''' TreeView 后发生的，而是在应用程序确定应允许用户尝试选择
    ''' 节点后发生。如果需要，应用程序使用相应的 BeforeSelect
    ''' 事件处理程序做出这一决定。所有 Before______ 事件
    ''' 都传递包含 Cancel 属性的 TreeViewCancelEventArgs 对象。
    ''' 可以使用该属性禁止用户的操作。因此，可将“AfterSelect”
    ''' 事件相应命名为“AfterSelectApproval”。
    ''' </summary>
    Private Sub TreeView1_AfterSelect(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles TreeView1.AfterSelect
        Dim SubDirectory As DirectoryNode = CType(e.Node, DirectoryNode)
        ListView1.Items.Clear()
        AddToListView(Format(SubDirectory.Size / (1024 * 1024), "F") + "MB", _
            SubDirectory.Text)
    End Sub
End Class